/*************************************************/
/* PublicSQL Version 1.2.1                       */
/* This programm is Open Source                  */
/* you can redistribute it and/or modify it      */
/* under the terms of the MIT-License            */
/*                                               */
/* More Info at license.txt                      */
/* or at:                                        */
/* www.opensource.org/licenses/mit-license.php   */
/*                                               */
/* Copyright by Jrg Siebrands, Germany, 2013    */
/*************************************************/

var porTables = new Array();			// array with tables in "Portable Table Format"
															
var publicSQL = (function ()	{
	
	/**********************/
	/* private properties */
	/**********************/	

	var nextArrayPos;				// temporary variable for next free position in porTables
	var browserType;				// "firefoxAndCo" or "ieAndCo"	
	var loadParameter = 0;	// for tableLoad if tableCache=false 
  var tableCache = true;	// "false" = direct load, no Browser-Cache / "false" verhindert Laden der Tabellen aus Browser-Cache 	

	/*********************/	
	/* private functions */
	/*********************/		
	
	/* second part of query(), executed after all tables are loaded */
	function query2(qc)	{
		var tarray = new Array();
		var darray = new Array(); 					// for "distinct=true"
		var qselect, qwhere, qorder
		var qorderNew;											// array with additional columns for ORDER BY statement // Array mit zustzichen Spalten fr ORDER BY Statement
		var tPosArray, tPosRows;
		var tPosIndex;
		var cols;
		var i,j,k, idx;
		var b;
		var c;
		var tb;
		var ende;
		var tempArray = new Array();			// help variable / Hilfsvariable
	
		/* copy row from darray to tarray if not avaible there / kopiert Zeile von darray nach tarray, wenn noch nicht vorhanden */
		function distinctAdd()	{
			var j,k;
			j=1;															// tarray row counter / tarray-Zeilenzhler
			while (j<tarray.length)	{					// all rows from tarray / alle Zeilen von tarray durchgehen
				k=0;														// darray row counter / darray-Zeilenzhler
				while (k < darray.length)	{			// search equal value / gleichen Wert suchen
					if (darray[k] == tarray[j][k])	{
						k++;												// next compare / fr nchster Vergleich
					} else {
						k=darray.length+1;					// at end condition because unequal items found / fr "unterschiedliches Element gefunden"
					}	// if 
				}	// while k
				if (k == (darray.length))	{			// self row found / gleiche Zeile gefunden
					j = (tarray.length+1);
				} else {												// not found / nicht gefunden
					j++; 													// next row in tarray / nchste Zeile in tarray
				} 	// if k
			}	// while j
			 if (j == (tarray.length))	{			// kein gleicher vorhanden				
				tarray[j] = new Array();
				for (k=0; k<darray.length; k++)	{
					tarray[j][k] = darray[k];								
				}
			}	// if j		
		}	// query2() -> distanceAdd()
	
		/* test of where condition, result is true (term complied with) or false / testet where-Bedingungen, gibt true (erfllt) oder false (nicht erfllt) zurck	*/
		function whereCondition()	{
			var i, j;
			var cp;
			var b = true;
			var t1, t2, s1, s2;
			var w1, w2;
			var s;
			var tp1, tp2;
			var bArray = new Array(qwhere.length);
			for (var i=0; i<qwhere.length; i++)	{				// run where-conditions / alle where-Bedingungen durchgehen			
				t1 = qwhere[i][0][0];											
				s1 = qwhere[i][0][1];		
				t2 = qwhere[i][1][0]; 
				s2 = qwhere[i][1][1];			
				if (s1 > -1)	{
					w1 = (typeof(tb[t1][tPosArray[t1] * cols[t1] + s1]) == "string") ? ("\"" + tb[t1][tPosArray[t1] * cols[t1] + s1] + "\"") : (tb[t1][tPosArray[t1] * cols[t1] + s1]);
				} else {
					w1 = (typeof(qc["where"][i][0]) == "string") ? ("\"" + qc["where"][i][0] + "\"") : qc["where"][i][0];
				}
				if (s2 > -1)	{
					w2 = (typeof(tb[t2][tPosArray[t2] * cols[t2] + s2]) == "string") ? ("\"" + tb[t2][tPosArray[t2] * cols[t2] + s2] + "\"") : (tb[t2][tPosArray[t2] * cols[t2] + s2]);
				} else {
					w2 = (typeof(qc["where"][i][2]) == "string") ? ("\"" + qc["where"][i][2] + "\"") : qc["where"][i][2];
				}
				cp = whereCompare(w1, w2);
				switch	(qc["where"][i][1])	{
					case "="	:					
						bArray[i] = (cp == 0);
						break;					
					case "<"		:	
						bArray[i] = (cp == -1);
						break;
					case ">"		:
						bArray[i]= (cp == 1);
						break;
					case "<>"	:
						bArray[i] = (cp != 0);
						break;
					case "<="	:
						bArray[i] = ((cp == -1) || (cp == 0));
						break;
					case ">="	:
						bArray[i] = (cp > -1);
						break;
					default:	
						bArray[i] = false;				// impossible value!
						break;
				}	// switch				
			}	// for i
			s = "b = (";
			for (i=0; i<bArray.length; i++)	{					// join term / Bedingung zusammensetzen
				if (i>0)	{	// AND/OR 
					if (qc["where"][i][5] == "A")	{
						s = s + " && ";
					} else if (qc["where"][i][5] == "O")	{
						s = s + " || ";
					}
				}
				s = s + qc["where"][i][6];			
				s = s + bArray[i];						
				s = s + qc["where"][i][7];			
			}	// for i		
			s = s + ")";
			eval(s);
			return b;
		}	// query2() -> whereCondition()
	
		// start query2 source
		tb = new Array();
		cols = new Array();		
		for(t=0; t<qc["from"].length; t++)	{			// assign table and number of columns / Tabelle und Spalten-Anzahl zuweisen
			tb[t] = porTables[publicSQL.tableNames[qc["from"][t]]];	
			cols[t] = tb[t][tb[t].length-1];	
		}		// for t			
		if (qc["select"][0][0] == "*")	{					// "*" -> columns of select-statement fill with columns of porTables / "*" = Spalten aus qc["select"] mit Spalten aller Tabellen fllen
			idx = 0;
			for(t=0; t<tb.length; t++)	{	// all tables 
				for (i=0; i<cols[t]; i++)	{	// all columns
					qc["select"][0][idx] = tb[t][i];	// field names from first row / Feld-Namen aus erster Zeile holen
					qc["select"][1][idx] = t;
					idx++;
				}
			}	
		}
		qselect = new Array();	// array with cols-indicies / zugehrige Spalten-Indizies
		for (i=0; i<qc["select"][0].length; i++)	{					// all select-items / Select-Elemente durchgehen
			t = qc["select"][1][i];
			for (j=0; j<cols[t]; j++)	{		// all columns
				if (tb[t][j] == qc["select"][0][i])	{	// found
					qselect[i] = j;
				}	
			}	// for j
		}	// for i

		if (qc["order"])	{
			qorder = new Array();
			for (i=0; i<qc["order"][0].length; i++)	{					// all order-items / Order-Elemente durchgehen
				t = qc["order"][1][i];
				for (j=0; j<cols[t]; j++)	{		// all columns
					if (tb[t][j] == qc["order"][0][i])	{	// found
						qorder[i] = j;
					}
				}	// for j
			}	// for i
		}	// if 
	
		if (qc["where"])	{																// save indicies of where-items / where Element-Indizies speichern
			qwhere = new Array(qc["where"].length);
			for (i=0; i<qc["where"].length; i++)	{					// all where-items / Where-Elemente durchgehen
				qwhere[i] = new Array();
				qwhere[i][0] = new Array(-1,-1);							// 	default values -> no column/table, relevant e. g. for null / Vorbelegungen -> keine Spalte/Tabelle, z.B. fr null relevant
				qwhere[i][1] = new Array(-1,-1);					
				for (t=0; t<tb.length; t++)	{																																		
					for (j=0; j<cols[t]; j++)	{				// all columns / fr alle Spalten
						if ((qc["where"][i][3] == t) && (tb[qc["where"][i][3]][j] == qc["where"][i][0]))	{					// found first value / 1. Wert gefunden
							qwhere[i][0] = new Array(t,j);
						}
						if ((qc["where"][i][4] == t) && (tb[qc["where"][i][4]][j] == qc["where"][i][2]))	{					// found second value / 2. Wert gefunden
							qwhere[i][1] = new Array(t,j);
						}
					}		// for j
				}		// for t
			}		// for i
		}		// qc["where"]		
		
		// build first row / erste Zeile aufbauen
		tarray[0] = new Array();
		for (i=0; i<qselect.length; i++)	{		
			if (!qc["as"])	{											// AS-statement available / AS-Statement vorhanden
				tarray[0][i] = qc["select"][0][i];
			} else {
				tarray[0][i] = qc["as"][i];				
			}
		}		

		// additional columns for ORDER BY statement / zustzliche Spalten fr ORDER BY
		if (qorder)	{
			qorderNew = new Array();							// array with additional columns for ORDER BY statement // Array mit zustzichen Spalten fr ORDER BY Statement
			for (i=0; i<qorder.length; i++)	{
				j=0;
				while (j < qselect.length)	{				// loop to exists columns / Schleife ber bereits vorhandene Spalten
					if (tarray[0][j] == qc["order"][0][i])	{		// exists / bereits vorhanden
						qorderNew[i] = j;
						j = 10000;	// fr Ende									
					}
					j++;					
				}		
				if (j < 10000) {	// new column	/ neue Spalte
					qorderNew[i] = tarray[0].length;
					tarray[0][tarray[0].length] = qc["order"][0][i];						
				}
			}
		}
																						
		// build content / Inhalt aufbauen
		tPosArray = new Array(tb.length);				// array with current positons / Array mit aktuellen Positionen
		tPosRows = new Array(tb.length);				// rows per table / Anzahl Zeilen pro Tabelle
		for(t=0; t<tb.length; t++)	{						// set 0 to start row for all tables / Startzeile fr alle Tabellen	auf 0 setzen
			tPosArray[t] = 1;											// start with row 1 (0 = fieldname) / Begin mit Zeile 1 (0 = Feldnamen)
			tPosRows[t] = (((tb[t].length-1) / cols[t]) - 1);
		}
		tPosIndex = tb.length-1;								// table which current is count up / Tabelle, die aktuell hochgezhlt wird
		ende = false;
		while (ende == false)	{															
			if (tPosArray[tPosIndex] > tPosRows[tPosIndex])	{					// index to high / Index zu hoch
				tPosIndex--;					// prev table as actual / vorige Tabelle als aktuelle
				if (tPosIndex > -1)	{		// if prev table exists / wenn Tabelle davor vorhanden
					tPosArray[tPosIndex]++; 	
				} else {								// no prev table / keine vorige Tabelle
					ende = true;
				}								
				while ((ende == false) && (tPosIndex >= 0) && (tPosArray[tPosIndex] > tPosRows[tPosIndex]))	{				// index to high again / Index immer noch zu hoch
					tPosArray[tPosIndex] = 1; 					
					if (tPosIndex == 0)	{
						ende = true;
					} else {
						tPosIndex--;						
						tPosArray[tPosIndex]++;
					}
				}	// while
				tPosIndex = tb.length-1;
				tPosArray[tPosIndex] = 1;
			}
			tPosIndex=tb.length-1;			
			if ((ende == false) && ((!qwhere) || (whereCondition() == true)))	{ 				// no condition -> copy / ohne Bedingung -> kopieren
				if (qc["distinct"] == false)	{																						// copy direct / direkt kopieren		
					tarray[tarray.length] = new Array(qselect.length);											// new row
					for (i=0; i<qselect.length; i++)	{																			// run through selected items / ausgewhlte Elemente durchgehen
						t = qc["select"][1][i];
						tarray[tarray.length-1][i] = tb[t][tPosArray[t]*cols[t]+qselect[i]];		
					}	// for j
					// order-columns: / order-Spalten:
					if (qorder)	{
						for (i=0; i<qorder.length; i++)	{
							if (qorderNew[i] >= qselect.length)	{																// additional order columns exists / zustzliche order Spalten vorhanden	
								t = qc["order"][1][i];
								tarray[tarray.length-1][qorderNew[i]] = tb[t][tPosArray[t]*cols[t]+qorder[i]]  
							}
						}
					}  					
				} else {	// distinct
					for (i=0; i<qselect.length; i++)	{																			// run through selected items / ausgewhlte Elemente durchgehen
						t = qc["select"][1][i];					
						darray[i] = tb[t][tPosArray[t]*cols[t]+qselect[i]];					
					}	// for j			
					distinctAdd();				
				}	// if
			}	// if qwhere
			tPosArray[tPosIndex]++;			
		}	// while ende == false
		
		// sort if ORDER BY statement exists / Sortieren wenn ORDER BY Statement existiert
		if (qc["order"])	{					
			if (qc["order"][2].length == 1)	{					// one item in array / ein Element im Array
				publicSQL.arraySort(tarray, qorderNew[0], qc["order"][2][0]);		
			} else {
				publicSQL.arraySort(tarray, qorderNew, qc["order"][2]);						
			}
			if (qselect.length < tarray[0].length)	{	// delete additional columns for ORDER BY / zuszliche Spalten fr ORDER BY lschen
				for (i=0; i<tarray.length; i++)	{
					tarray[i].length = qselect.length;
				}
			}
		}		
		s = qc["func"] + "(tarray)";
		eval(s);					// call passed function with table as argument / Aufruf der bergebenen Funktion mit Tabelle als Parameter			
	}	

	/* load table, if needful. afterwords call function query2() / ldt Tabellen, wenn ntig und ruft anschlieend query2() auf */
	function tableLoader(qc)	{				
		if (qc["fromNextLoad"] < qc["from"].length)	{																							
			if (eval('typeof publicSQL.tableNames[qc["from"][qc["fromNextLoad"]]]') == "number") {	// table is already loaded / Tabelle schon geladen
				qc["fromNextLoad"]++;			
				tableLoader(qc);
			} else {																			// must load / muss geladen werden
				loadTable(qc);
			}
		} else {																				// all tables loaded / alle Tabellen geladen
			query2(qc);																		// ok -> next step / ok -> nchster Schritt
		}
	}	// tableLoader()
	
	/* subfunction from tableLoader() */
	function loadTable2(qc) {
		if (eval("typeof porTables[nextArrayPos]") != "object") {	
			if(browserType == "firefoxAndCo") {
				return false;
			} 
			window.setTimeout(function() {loadTable2(qc);},1);
		} 
		publicSQL.tableNames[qc["from"][qc["fromNextLoad"]]] = nextArrayPos;		// now table is loaded / ab hier ist die Tabelle geladen
		qc["fromNextLoad"]++;
		tableLoader(qc);
		return true;
	}	// loadTable2()
	
	/* subfunction from tableLoader() */	
	function loadTable(qc) {
		nextArrayPos	= porTables.length;
		var Head = document.getElementsByTagName("head")[0];
		var Script = document.createElement('script');
		if (tableCache == true)	{
			var s = publicSQL.tablePath + qc["from"][qc["fromNextLoad"]] + "." + publicSQL.tableExtension;
		} else {
			var s = publicSQL.tablePath + qc["from"][qc["fromNextLoad"]] + "." + publicSQL.tableExtension + "?x=" + loadParameter;					
		}
		Script.setAttribute('src', s);
		Script.setAttribute('type', 'text/javascript');
		if (browserType == "firefoxAndCo") {			// firefox compatible
			Script.onload= function() { loadTable2(qc); };
			Head.appendChild(Script);
		}																		
		else {															// Internet Explorer, older version
			Head.appendChild(Script);	
			loadTable2(qc);				
		} 
	}	// loadTable()
	
	/* sort-function for WHERE-Statement, return(-2) when one value is null */
	function whereCompare(v1, v2)	{
		var ret;									
		if ((v1 == null) != (v2 == null)) {			// null at top
			ret = -2;			
		} else {
			ret = sortCompare(v1,v2);
		}
		return(ret);
	}	// whereCompare()	
	
	/* sort-function */
	function sortCompare(v1, v2)	{
		var ret;
		if ( (typeof(v1) == "number") != (typeof(v2) == "number") )	{		// one number -> change to string
			if (typeof(v1) == "number")	{
				v1 = v1.toString();
			} else {
				v2 = v2.toString();
			}
		}
		if ((v1 == null) != (v2 == null)) {															// null at top
			ret = (v1 == null) ? -1 : 1;
		} else if(isNaN(v1) == false && isNaN(v2) == false)	{						// two numbers
			if (v1 == v2)	{
				ret = 0;
			} else {
				ret = (v1 < v2) ? -1 : 1;
			}
		} else if(v1.toLowerCase() < v2.toLowerCase())	{								// two different strings
			ret = -1;
		} else if(v2.toLowerCase() < v1.toLowerCase())	{								// "   "         "
			ret = 1;
		}	else if(v1.toLowerCase() == v2.toLowerCase())	{								// two equal strings
			if(v1 < v2)	{
				ret = -1;
			}	else if (v2 < v1)	{
				ret = 1;
			}	else	{
				ret = 0;
			}
		}
		return(ret);						
	}	// sortCompare()	

	/********************/	
	/* public interface */
	/********************/		
	
	return	{
		
		/*********************/	
		/* public properties */
		/*********************/	
		
		tableNames 	: new Array(),			// assoziatives Array: Zugriff ber Tabellenname, Ergebnis = Index der Tabelle in porTables
		tableExtension	: "ptf",				// 
		tablePath		: "",
		htmlStandardTable	: "defaultTable",		// standard-html-table-id in show()
		nullValue		: "-",							// string for value null in show()
		errorNumber : 0,								// identifier for errors
		errorText		: "",								// fragment which includes the error
		
		/********************/	
		/* public functions */
		/********************/		
		
		/* set to "false" = direct load, no Browser-Cache / auf "false" setzen verhindert Laden der Tabellen aus Browser-Cache */
		setTableCache : function(b)	{
			if (b != tableCache)	{																		// value tableache changed
				tableCache = b;				
				if ((tableCache == false) && (loadParameter == 0))	{		// first time
					var act 			= new Date();
					var actTime		= act.getTime() / 1000;											// actual time in seconds
					var start			= new Date(2013, 0, 1, 0, 0, 0)							// Start with Jan 1, 2013 - after published this script 
					var startTime	= start.getTime() / 1000;										// in seconds
					loadParameter	= Math.floor(startTime - actTime);
				}	// if tableCache...
			}	// if b...
		},	// setTableCache
		
		/* get Browser-Cache state: true (default) = load tables from Browser-Cache if activated, false = no Browser-Cache	*/
		getTableCache : function()	{
			return tableCache;
		},	

  	/* sort function. arr = array to sort, col = column(s) to sort, asc = ascending(true) or descending(false)*/
		arraySort : function(arr, col, asc)	{
			var hlp;
			var i, j, k;
			var dir;
			var dirArray = new Array();
			var cp;
			if (typeof col == "number")	{
				if (typeof(asc) == "object")	{
					dir = (typeof(asc[0]) == "boolean") ? asc[0] : true;
				} else {
					dir = (typeof(asc) == "boolean") ? asc : true;
				}				
				if ((col >= arr[0].length) || (col < 0)) return;		// column not exists	
				for(i=1; i<arr.length-1; i++){
					for(j=(i+1); j<arr.length; j++){
						cp = sortCompare(arr[i][col], arr[j][col]);
						if ((asc == true) && (cp > 0))	{								// asc -> change
							hlp = arr[i];
							arr[i] = arr[j];
							arr[j] = hlp;
						} else if ((asc == false) && (cp < 0))	{				// desc -> change
							hlp = arr[i];
							arr[i] = arr[j];
							arr[j] = hlp;
						}
					}	// for j
				}	// for i
			} else if (typeof col == "object")	{	// col is an array
				for(i=0; i<col.length; i++)	{
					if ((col[i] >= arr[0].length) || (col[i] < 0))	{		// is not column
						col[i] = -1;																			// -1 -> column-error
					}
					if (typeof(asc) == "object")	{
						dirArray[i] = (typeof(asc[i]) == "boolean") ? asc[i] : true;
					} else {
						dirArray[i] = (typeof(asc) == "boolean") ? asc : true;
					}					
				}
				for(i=1; i<arr.length-1; i++)	{
					for(j=(i+1); j<arr.length; j++)	{
						k = 0;
						while (k < col.length)	{							
							if (col[k] == -1)	{					// no column-error
								k++;
							} else {										// no column-error
								cp = sortCompare(arr[i][col[k]], arr[j][col[k]]); 							
								dir = dirArray[k];
								if (dir == true)	{
									if (cp > 0)	{						// bigger?	
										hlp = arr[i];
										arr[i] = arr[j];
										arr[j] = hlp;
										k = col.length;
									}	else {
										k = (cp == 0) ? k+1 : col.length;					// equal or bigger	
									}
								}	else {									// if descending
									if (cp < 0)	{						// less?
										hlp = arr[i];
										arr[i] = arr[j];
										arr[j] = hlp;
										k = col.length;
									}	else {
										k = (cp == 0)	? k+1 : col.length;					// equal or less
									}	// cp						
								}	// asc / desc
							}	// col[k] == -1?
						}	// while
					}	// for j
				}	// for i
			}	// tpye = array
		},	// arraySort()

		/* delete table by id */
		htmlTableDelete : function(tid)	{
			var tp;
			var tb;
			tp = typeof tid;
			switch (tp)	{
				case "string"	:
					tb = document.getElementById(tid);
					break;
				case "number"	:
					tb = document.getElementsByTagName("table")[tid];
					break;
				case "object"	:
					tb = tid;
					break;
				default	:
					return;	// error !
			}
			while(tb.rows.length>0)  	{			// delete elements 
		    tb.deleteRow(0);
		  }
			tb.deleteTFoot();
			tb.deleteTHead();
			tb.cellPadding = 0;
			tb.cellSpacing = 0;
		},	// htmlTableDelete()

		/* show table. t = table-array, ident (optional) = table-id or number of table on the page or table as object */
		show : function(t, ident)	{
			var i,j;
			var s;
			var tr, td, th, tbody, ttext, tid;
			var tp;
			tp = typeof ident;
			tid = "";
			switch (tp)	{
				case "string"	:
					tb = document.getElementById(ident);		
					tid = ident;
					break;
				case "number"	:
					tb = document.getElementsByTagName("table")[ident];					
					if (tb == null)	{
						tid = publicSQL.htmlStandardTable;
					}
					break;
				case "object"	:
					tb = ident;		
					tid = tb.getAttribute("ID", 0);					
					break;
				default	:		// not exists / nicht vorhanden
					tid = publicSQL.htmlStandardTable;
					tb = document.getElementById(tid);						
					break;																									
			}		
			if ((typeof (tb) != "object") || (tb == null))	{
				tb = document.createElement("table");
				tb.setAttribute("Border", 1, 0);
				tb.setAttribute("ID", tid, 0);				
				document.getElementsByTagName("body")[0].appendChild(tb);
			} else {
				publicSQL.htmlTableDelete(tb);								
			}
			// body...
			tbody = document.createElement("tbody");			
			// fill first row
			tr = document.createElement("tr");
			th = document.createElement("th");						// 1. column = row-number...
			ttext= document.createTextNode(" ");
			th.appendChild(ttext);
			tr.appendChild(th);	
			for (i=0; i<t[0].length; i++)	{ 	
				th = document.createElement("th");				
				s = t[0][i];
				ttext= document.createTextNode(s);
				th.appendChild(ttext);
				tr.appendChild(th);				
			}
			tbody.appendChild(tr);				
			for (i=1; i<t.length; i++)	{
				tr = document.createElement("tr");			
				td = document.createElement("td");					// 1. column = row-number
				ttext= document.createTextNode(i);
  			td.appendChild(ttext);
				td.style.fontWeight = "bold";
				tr.appendChild(td);													
				for (j=0; j<t[i].length; j++)	{
					td = document.createElement("td");
					if ((typeof t[i][j] == "object")	&& (t[i][j] == null))	{
						s = publicSQL.nullValue;
					} else {
						s = t[i][j];
					}
					ttext= document.createTextNode(s);
					td.appendChild(ttext);
					tr.appendChild(td);									
				}	// for j
				tbody.appendChild(tr);				
			}	// for i	
			tb.cellPadding = 1;
			tb.cellSpacing = 0;	
			tb.appendChild(tbody);
		},	// show()
							
		query : function(qselect, qfunc)	{
			var i, j;
			var b;
			var c;
			var s;
			var idx;
			var qfrom, qwhere, qorder = "";
			var qc = new Array();
			var tempArray, tempArray2, tempArray3 = new Array();
			var tabAliasArray = new Array();						// alias-names from qc["from"] / erhlt Alias-Namen zu qc["from"]
			var notfound;
			var delimiterArray = new Array();						// psoition of quotes, true = string with quotes / Positionen von Anfhrungszeichen; true = String mit Anfhrungszeichen
			var agent;
																												
			publicSQL.errorNumber = 0;		// default = no error
			publicSQL.errorText = "";			// default = no error text 
			// recognition of browser / Browser-Erkennung	
			agent = navigator.userAgent.toLowerCase(); 						
			if ((agent.toLowerCase().indexOf("msie") >-1 ) && (parseInt(navigator.appVersion) <= 4))	{  		//	Internet-Explorer, old version
				browserType = "ieAndCo";
			}  else {
				browserType = "firefoxAndCo";
			}	  			
		
			/* fill delimiterArray with string-positions of with quotes delimited strings / fllt DelimiterArray mit String-Positionen der durch Anfhrungszeichen begrenzten Strings	*/
			function setDelimiterArray(s)	{
				var i;
				var c;
				var found1 = "";
				delimiterArray.length = s.length;																								
				for (i=0; i<s.length; i++)	{		// defaulte = true -> no with qouotes delimited string / Vorgabe = true -> kein String in Anfhrungszeichen
					c = s.charAt(i); 
					switch (found1) {							// if necessary: 1. quote search - find backslash before - 2. quote search / je nach Zustand: 1. Begrenzer suchen - vorher Backslash gefunden - 2. Begrenzer suchen
						case ""		:									// no quote find before / vorher kein Begrenzer gefunden
							switch (c)	{						
								case "'"	:
								case '"'	:						
								case "`"	:
									found1 = c;
									delimiterArray[i] = false;
									break;													
								case "\\"	:					
									found1 = c;
									delimiterArray[i] = true;							
									break;
								default		:
									delimiterArray[i] = true;														
									break;
							}	// switch s[i]
							break;
						case "\\"	:									// backslash (escape sequence) found before / vorher Maskierungszeichen Backslash gefunden 
							found1 = "";
							delimiterArray[i] = true;												
							break;
						case "'"	:									// quote found before / vorher Begrenzer gefunden
						case '"'	:						
						case "`"	:
							delimiterArray[i] = false;																													
							if ((c == found1) && (s.charAt(i-1) != "\\"))	{					// wenn 2. Begrenzer und nicht maskiert
								found1 = "";
							}	
							break;
					}	// switch found1
				} // for i
			}	// setDelimiterArray()
		
			/* summarize whitespaces by qselect / fasst mehrere Leerzeichen bei qselect zu einem zusammen	*/
			function mergeQuerySpaces()	{
				var i, p;
				var inSpace = false;
				var c;
				for (i=qselect.length-1; i>=0; i--)	{
					c = qselect.charAt(i);
					if (inSpace == false)	{			
						switch(c)	{
							case " "	:
							case "\n"	:
							case "\f"	:
							case "\b"	:
							case "\r"	:
							case "\t"	:
							case "\xA0"	:		// geschtztes Leerzeichen
								if (delimiterArray[i] == true)	{	// nicht innerhalb von String
									inSpace = true;							
									p = i;
								} 																									
								break;
						}	// switch c
					}	else {						// inSpace == true
						switch(c)	{
							case " "	:
							case "\n"	:
							case "\f"	:
							case "\b"	:
							case "\r"	:
							case "\t"	:
							case "\xA0"	:		// geschtztes Leerzeichen
								break;
							default		:
								inSpace = false;
								qselect = qselect.slice(0,i+1) + ' ' + qselect.slice(p+1);
								delimiterArray.splice(i+1, (p-i-1));
								break;
						} // switch c
					}	// inSpace?
				}	// for i
			}	//
		
			/* search word "w" in string "s" considering of delimiterArray - case insensitivity */
			/* such Wort "w" in String "s" unter Bercksichtigung von delimiterArray, Gro- / Kleinschreibung wird nicht bercksichtigt. */
			function getWordPos(s, w)	{
				var p = -1;			
				var found = -1;
				w = w.toLowerCase(w);
				do	{
					p = s.toLowerCase().indexOf(w,p+1);
					if (delimiterArray[p] == true)	{
						found = p;
					}
				} while ((p != -1) && (delimiterArray[p] == false));
				return found;
			}	// getWordPos()

			/* split string "s" considering of delimiterArray by positions with string "w", result = array with located substrings, case insensitivity */
			/* splittet String "s" unter Bercksichtigung von delimiterArray  an Positionen mit "w" auf. Rckgabewert = Array mit gefundenen Teilstrings. Gro-/Kleinschreibung ist egal */
			function splitStatement(s, w)	{
				var p = -1;
				var lastp = 0;
				var na = new Array;
				do	{
					p = s.toLowerCase().indexOf(w.toLowerCase(), lastp);
					if ((p != -1) && (delimiterArray[p] == true))	{
						na[na.length] = s.slice(lastp, p);
						lastp = p+w.length;
					} else {
						break;
					}
				} while (p != -1);
				if (lastp < s.length)	{
					na[na.length] = s.slice(lastp);		
				}
				return na;
			}	// splitStatement()
		
			qselect = qselect.replace(/^\s+/g, "");			// delete quote at first / Leerzeichen am Anfang entfernen
			qselect = qselect.replace(/\s+$/g, "");			// delete quote at the end / Leerzeichen am Ende entfernen
			setDelimiterArray(qselect);
			mergeQuerySpaces();
			
			// ORDER BY Search
			idx = getWordPos(qselect, "ORDER BY");					// find "ORDER BY", if not in quotes / findet ORDER BY, wenn nicht in Anfhrungszeichen
			if (idx != -1) {
				qorder = qselect.substring(idx+8);
				qselect = qselect.substring(0, idx);
				b = qorder.match(/\s+\S+(\s+(ASC|DESC))?\s*(,\s+\S+(\s+(ASC|DESC))\s*)*\s*/i);
				if (!b) {
					publicSQL.errorNumber = 50;
					publicSQL.errorText = qorder;
					return;
				}				
			}				
																												
			// WHERE-Search
			idx = getWordPos(qselect, "WHERE");					// find "WHERE", if not in quotes / findet WHERE, wenn nicht in Anfhrungszeichen
			if (idx != -1) {
				qwhere = qselect.substring(idx+5);
				qselect = qselect.substring(0, idx);
				b = qwhere.match(/\s+\S+\s+(=|<>|<|>|>=|<=)\s+\S+(\s+(AND|OR)\s+\S+\s+(=|<>|<|>|>=|<=)\s+\S+)*\s*/i);
				if (!b) {
					publicSQL.errorNumber = 30;
					publicSQL.errorText = qselect;
					return;
				}				
			}		
		
			// FROM
			idx = getWordPos(qselect, "FROM");
			if (idx == -1) {
				publicSQL.errorNumber = 20;
				publicSQL.errorText = qselect;
				return;
			} else {
				qfrom = qselect.substring(idx+4);
				qselect = qselect.substring(0, idx);
				b = qfrom.match(/\s+\S+(\s+\S+)?\s*(,\s*\S+(\s+\S+)?\s*)*/i);
				if (!b) {
					publicSQL.errorNumber = 21;
					publicSQL.errorText = qfrom;
					return;
				}		
			}
																														
			/* handling query-statement / Verarbeitung der Query-Bestandteile */
			
			/* handling from-statement / FROM-Verarbeitung */
			qfrom = qfrom.replace(/\s+$/g, "");										// delete right whitespaces / Leerzeichen am Ende entfernen	
			setDelimiterArray(qfrom);  
			//	tabAliasArray parallel zu qfrom-array fllen
			qc["from"] = new Array();			
			tempArray = splitStatement(qfrom, ",");
			for (i=0; i<tempArray.length; i++)	{
				tempArray[i] = tempArray[i].replace(/^\s+/g, "");		// delete left whitespaces / Leerzeichen am Anfang entfernen
				tempArray[i] = tempArray[i].replace(/\s+$/g, "");		// delete right whitespaces / Leerzeichen am Ende entfernen							
				setDelimiterArray(tempArray[i]);
				tempArray2 = splitStatement(tempArray[i], " ");		
				qc["from"][i] = tempArray2[0];											// field
				if (tempArray2.length > 1)	{												// alias located / Alias gefunden
					tabAliasArray[i] = tempArray2[1];									// alias
				}	else {																						// without alias -> save void string / ohne Alias -> Leerstring speichern
					tabAliasArray[i] = "";
				}	 
			}	// for i
		
			/* handling where-statement / WHERE-Verarbeitung */
			if (qwhere)	{																					// where statement exists / WHERE-Anweisung vorhanden
				qwhere = qwhere.replace(/\s+$/g, "");								// delete right whitespaces / Leerzeichen am Ende entfernen		
				setDelimiterArray(qwhere);		
				tempArray = splitStatement(qwhere, " and ");				// search "AND" / AND suchen	
				for (i=1; i<tempArray.length; i++)	{								// set identifier for "AND" / and setzen
					setDelimiterArray(tempArray[i]);		
					tempArray[i] = "A" + tempArray[i];
				}
				k = 0;	
				tempArray3.length = 0;
				for (i=0; i<tempArray.length; i++)	{													// search "OR" / OR suchen
					setDelimiterArray(tempArray[i]);				
					tempArray2 = splitStatement(tempArray[i], " or ");						
					for (j=0; j<tempArray2.length; j++)	{
						if (j>0) {																								// if not first item / wenn nicht erstes Element
							tempArray2[j] = "O" + tempArray2[j];
						}
						tempArray2[j] = tempArray2[j].replace(/^\s+/g, "");				// delete left whitespaces / Leerzeichen am Anfang entfernen
						tempArray3[k++] = tempArray2[j];													// items splited by "OR" -> save in tempArray3 / splitted alle durch OR getrennte Teile in tempArray3
					}
				}
				tempArray = tempArray3;																				// starting from now tempArray includes all where-substings / enthlt ab jetzt alle Teil-Strings von WHERE		
				qc["where"] = new Array();
				for (i=0; i<tempArray.length; i++)	{
					qc["where"][i] = new Array();						
					tempArray[i] = tempArray[i].replace(/^\s+/g, "");						// delete left whitespaces / Leerzeichen am Anfang entfernen			
					if (i>0)	{			// AND bzw. OR speichern
						qc["where"][i][5] = tempArray[i].substr(0,1);
						tempArray[i] = tempArray[i].substr(1);
					}			
		
					// bracket interpretation / Klammern auswerten
					s = "";
					while (tempArray[i].search(/^(\(|not|\s)/i) > -1)	{										// search left brackets / Klammern vorne suchen
						c = tempArray[i].charAt(0);					
						if (c == "(")	{
							s = s + c;
							tempArray[i] = tempArray[i].substr(1);								
						} else if (tempArray[i].substr(0,3).toLowerCase() == "not")	{				// not locatet / not gefunden
							s = s + "!";
							tempArray[i] = tempArray[i].substr(3);													
						} else {			// Leerzeichen
							tempArray[i] = tempArray[i].substr(1);																	
						}
					} 
					qc["where"][i][6] = s;						
					s = "";
					j = tempArray[i].length-1;
					c = tempArray[i].charAt(j);
					while ((j >= 0) && ((c == ")") || (c == " ")))	{											// search right brackets / Klammern hinten suchen
						if (c == ")")	{
							s = s + c;
						}
						j--;
						c = tempArray[i].charAt(j);							
					}	
					tempArray[i] = tempArray[i].substring(0,j+1);			
					qc["where"][i][7] = s;									
					
					setDelimiterArray(tempArray[i]);					
					tempArray2 = splitStatement(tempArray[i], " ");							// items of where-statement / Einzelbestandteile der Bedingung

					// allocate first value of term / ersten Wert der Bedingung zuweisen		
					idx = tempArray2[0].search(/^(\"|\'|\`).*(\"|\'|\`)$/);			// quotes exists? / Anfhrungszeichen vorhanden?
					if (idx > -1)	{																							// quote? / Anfhrungszeichen?
						tempArray2[0] = tempArray2[0].replace(/^./, "");					// delete left quote / vorderes Anfhrungszeichen lschen
						tempArray2[0] = tempArray2[0].replace(/.$/, "");					// delete right quote / hinteres Anfhrungszeichen lschen
						qc["where"][i][0] = tempArray2[0];	// Feld					
						qc["where"][i][3] = -1;				
					} else if ((parseFloat(tempArray2[0])) != tempArray2[0]) {		// no quotes and not a number -> must be a field / keine Anfhrungszeichen, auch keine Zahl -> muss Feldname sein
						idx = tempArray2[0].search(/\./);													// table identifier exists? / Tabellenbezeichner vorhanden?
						if (idx > -1)	{																						// yes, exists / ja, existiert
							tempArray3 = tempArray2[0].split(".");
							qc["where"][i][0] = tempArray3[1];											// field / Feld			
							j=0;
							while (j<qc["from"].length)	{														// table search / Tabelle suchen
								if ((tempArray3[0] == tabAliasArray[j]) || (tempArray3[0] == qc["from"][j]))	{			// located in FROM-statement or in alias-table / in FROM-Statement oder Alias-Tabelle gefunden
									qc["where"][i][3] = j;
									j = qc["from"].length;
								}
								j++;
							}
							if (j == qc["from"].length)	{									// table not located / Tabelle nicht gefunden
								qc["where"][i][3] = -1;											// table not located -> in fact an error, here we assume that it is a string-value / fr "keine Tabelle", eigentlich ein Fehler -> hier wird der Wert dann als String gewertet
							}										
						} else {																				// no table-identifier located / kein Tabellenbezeichner vorhanden
							if (tempArray2[0].toLowerCase() == "null")	{	// NULL ?
								qc["where"][i][0] = null;															
								qc["where"][i][3] = -1;			
							} else {
								qc["where"][i][0] = tempArray2[0];					// table-field
								qc["where"][i][3] = 0;											// default first table, if unspecified / standardmig erste Tabelle, wenn nicht angegeben
							}
						}
					} else {	// number / Wert ist Zahl
						qc["where"][i][0] = parseFloat(tempArray2[0]);		
						qc["where"][i][3] = -1;				
					}	// if string, number or field-value / wenn String, Zahl oder Feldwert ?

					// allocate second value of term / zweiten Wert der Bedingung zuweisen					
					idx = tempArray2[2].search(/^(\"|\'|\`).*(\"|\'|\`)$/);			// quotes exists? / Anfhrungszeichen vorhanden?
					if (idx > -1)	{																							// quote? / Anfhrungszeichen?
						tempArray2[2] = tempArray2[2].replace(/^./, "");					// delete left quote / vorderes Anfhrungszeichen lschen
						tempArray2[2] = tempArray2[2].replace(/.$/, "");					// delete right quote / hinteres Anfhrungszeichen lschen		
						qc["where"][i][2] = tempArray2[2];												// field
						qc["where"][i][4] = -1;				
					} else if ((parseFloat(tempArray2[2])) != tempArray2[2]) {		// no quotes and not a number -> must be a field / keine Anfhrungszeichen, auch keine Zahl -> muss Feldname sein
						idx = tempArray2[2].search(/\./);													// table identifier exists? / Tabellenbezeichner vorhanden?
						if (idx > -1)	{																						// yes, exists / ja, existiert
							tempArray3 = tempArray2[2].split(".");			
							qc["where"][i][2] = tempArray3[1];											// field
							j=0;
							while (j<qc["from"].length)	{														// table search / Tabelle suchen
								if ((tempArray3[0] == tabAliasArray[j]) || (tempArray3[0] == qc["from"][j]))	{			// located in FROM-statement or in alias-table / in FROM-Statement oder Alias-Tabelle gefunden
									qc["where"][i][4] = j;
									j = qc["from"].length;
								}
								j++;			
							}
							if (j == qc["from"].length)	{									// table not located / Tabelle nicht gefunden
								qc["where"][i][4] = -1;											// table not located -> in fact an error, here we assume that it is a string-value / fr "keine Tabelle", eigentlich ein Fehler -> hier wird der Wert dann als String gewertet
							}	// if					
						} else {																				// no table-identifier located / kein Tabellenbezeichner vorhanden
							if (tempArray2[2].toLowerCase() == "null")	{	// NULL ?
								qc["where"][i][2] = null;	
								qc["where"][i][4] = -1;						
							} else {
								qc["where"][i][2] = tempArray2[2];					// table-field
								qc["where"][i][4] = 0;											// default first table, if unspecified / standardmig erste Tabelle, wenn nicht angegeben 
							}				
						}
					} else {	//number / Wert ist Zahl
						qc["where"][i][2] = parseFloat(tempArray2[2]);	
						qc["where"][i][4] = -1;				
					}	// if string, number or field-value / if String, Zahl oder Feldwert ?
					qc["where"][i][1] = tempArray2[1];
				}	// for
			}	// where?

			/* handling ORDER BY statement / ORDER BY Verarbeitung */
			if (qorder)	{																					// ORDER BY statement exists / ORDER BY Anweisung vorhanden
				qorder = qorder.replace(/\s+$/g, "");										// delete right whitespaces / Leerzeichen am Ende entfernen	
				setDelimiterArray(qorder);  
				qc["order"] = new Array();
				qc["order"][0] = new Array();	// field
				qc["order"][1] = new Array();	// table alias	/ Tabellen-Alias
				qc["order"][2] = new Array();	// sort directions: 0=asc, 1=desc / Sortierrichtung: 0=absteigend, 1=aufsteigend				
				
				tempArray = splitStatement(qorder, ",");				
				for (i=0; i<tempArray.length; i++)	{
					tempArray[i] = tempArray[i].replace(/^\s+/g, "");		// delete left whitespaces / Leerzeichen am Anfang entfernen
					tempArray[i] = tempArray[i].replace(/\s+$/g, "");		// delete right whitespaces / Leerzeichen am Ende entfernen							

					// ASC/DESC
					qc["order"][2][i] = Boolean(true); // ascending as default / Voreinstellung aufsteigend sortieren
					setDelimiterArray(tempArray[i]);  					
					idx = getWordPos(tempArray[i], " ASC");
					if (idx > -1)	{	
						tempArray[i] = tempArray[i].substring(0, idx);						
					} else {															
						idx = getWordPos(tempArray[i], " DESC");
						if (idx > -1)	{
							qc["order"][2][i] = Boolean(false);			// descending / absteigend sortieren						
							tempArray[i] = tempArray[i].substring(0, idx);													
						}
					}

					idx = tempArray[i].search(/\./);
					if (idx > -1)	{		// table identifier / Tabellen-Bezeichner
						tempArray2 = tempArray[i].split(".");
						qc["order"][0][i] = tempArray2[1];							// field
						j=0;
						while (j<qc["from"].length)	{
							if ((tempArray2[0] == tabAliasArray[j]) || (tempArray2[0] == qc["from"][j]))	{				// located in FROM-statement or in alias-table / in FROM-Statement oder Alias-Tabelle gefunden
								qc["order"][1][i] = j;	// table index / Tabellen-Index
								j = qc["from"].length;	// for loop end condition / fr Schleifen-Ende
							}
							j++;
						}
						if (j == qc["from"].length)	{										// table not located / Tabelle nicht gefunden
							publicSQL.errorNumber = 51;
							publicSQL.errorText = tempArray2[0];
							return;
						}
					} else {																				// no table-identifier located / kein Tabellenbezeichner vorhanden
						if (qc["from"].length != 1)	{		// more than 1 table exists / mehr als eine Tabelle vorhanden
							publicSQL.errorNumber = 52;
							publicSQL.errorText = tempArray2[0];
							return;
						} else {	// use the only table / die einzige vorhandene Tabelle verwenden
							qc["order"][0][i] = tempArray[i];						// field					
							qc["order"][1][i] = 0;
						}
					}	// if (idx > -1)			
				}	// for i
			} // order by?

			// Handling SELECT statement
			qselect = qselect.replace(/^\s+/g, "");			// delete left whitespaces / vordere Leerzeichen lschen
			qselect = qselect.replace(/\s+$/g, "");			// delete right whitespaces  / hintere Leerzeichen lschen	
			setDelimiterArray(qselect);  
			idx = getWordPos(qselect, "SELECT");	
			if (idx == -1)	{
				publicSQL.errorNumber = 10;
				publicSQL.errorText = qselect;
				return;
			} else {
				qselect = qselect.substring(idx+6);
				qselect = qselect.replace(/^\s+/g, "");			// delete left whitespaces / vordere Leerzeichen lschen
				b = qselect.match(/\s*(DISTINCT\s+)?(\*\s+|(\S+\.\S+\s*|\S+\s*)(,\s*\S+\.\S+\s*|,\s*\S+\s*)*\s*)/i);
				if (!b) {
					publicSQL.errorNumber = 11;
					publicSQL.errorText = qselect;
					return;
				}
			}
			setDelimiterArray(qselect); 
			idx = getWordPos(qselect, "DISTINCT");
			if (idx == 0)	{															// DISTINCT ?
				qselect = qselect.substring(idx+8);
				qc["distinct"] = true;
			}	else {
				qc["distinct"] = false;
			}
			qselect = qselect.replace(/^\s+/g, "");								// delete left whitespaces / vordere Leerzeichen lschen
			qc["select"] = new Array();		
			qc["select"][0] = new Array();	// field / Feld
			qc["select"][1] = new Array();	// table / Tabelle
			if (qselect == "*")	{																	// all fields from all tables / alle Felder u. alle Tabellen
				qc["select"][0] = new Array("*");										// identification for special case "*" / Kennzeichnung fr Sonderfall "*"
			} else {																							// only specific fields / nur bestimmte Felder
				tempArray = qselect.split(",");
				for (i=0; i<tempArray.length; i++)	{
					tempArray[i] = tempArray[i].replace(/^\s+/g, "");	// delete left whitespaces / vordere Leerzeichen lschen
					tempArray[i] = tempArray[i].replace(/\s+$/g, "");	// delete right whitespaces  / hintere Leerzeichen lschen		
					idx = qselect.search(/\./);
					if (idx > -1)	{	
						tempArray2 = tempArray[i].split(".");
						qc["select"][0][i] = tempArray2[1];							// field
						j=0;
						while (j<qc["from"].length)	{
							if ((tempArray2[0] == tabAliasArray[j]) || (tempArray2[0] == qc["from"][j]))	{				// located in FROM-statement or in alias-table / in FROM-Statement oder Alias-Tabelle gefunden
								qc["select"][1][i] = j;
								j = qc["from"].length;
							}
							j++;
						}
						if (j == qc["from"].length)	{										// table not located / Tabelle nicht gefunden
							publicSQL.errorNumber = 12;
							publicSQL.errorText = tempArray2[0];
							return;
						}
					} else {																					// no table-identifier located / kein Tabellenbezeichner vorhanden
						if (qc["from"].length != 1)	{
							publicSQL.errorNumber = 13;
							publicSQL.errorText = tempArray2[0];
						} else {
							qc["select"][0][i] = tempArray[i];						// field					
							qc["select"][1][i] = 0;
						}
					}	// if (idx > -1)

					// handling AS-statement / AS-Statement auswerten
					setDelimiterArray(qc["select"][0][i]); 
					idx = getWordPos(qc["select"][0][i], "AS");					
					if (idx > -1)			{																// locate "AS" 
						s = qc["select"][0][i].replace(/\sas\s/i, " ");	// modify "AS" to whitespace / AS-in Leerzeichen wandeln
						qc["select"][0][i] = s;	
					}
					qc["select"][0][i] = qc["select"][0][i].replace(/^\s+/g, "");	// delete left whitespaces / vordere Leerzeichen lschen
					qc["select"][0][i] = qc["select"][0][i].replace(/\s+$/g, "");	// delete right whitespaces  / hintere Leerzeichen lschen							
					setDelimiterArray(qc["select"][0][i]); 
					idx = getWordPos(qc["select"][0][i], " ");				// whitespace = "AS" / Leerzeichen = AS	
					if ((idx > -1) || (qc["as"]))	{										// handlung "AS"? / AS-Verarbeitung?
						if (!qc["as"])	{																// array not yet initialized / Array noch nicht initialisiert?
							qc["as"] = new Array();		
							for (j = 0; j<i; j++)	{												// fehlende Elemente fllen
								qc["as"][j] = qc["select"][0][j];
							}
						}
						if (idx > -1)	{																	// split an make entry for "AS" / Splitten und AS-Eintrag vornehmen
							tempArray2 = splitStatement(qc["select"][0][i], " ");							
							qc["select"][0][i] = tempArray2[0];
							qc["as"][i] = tempArray2[1];					
						} else {																				// take select-table to "AS"-array / Select-Tabelle in AS-Array bernehmen
							qc["as"][i] = qc["select"][0][i];										
						}
						qc["as"][i] = qc["as"][i].replace(/^(\"|\')/, "");			// delete left quotes / linke Anfhrungszeichen lschen				
						qc["as"][i] = qc["as"][i].replace(/(\"|\')$/, "");			// delete right quotes / rechte Anfhrungszeichen lschen
					}
				}	// for i
			}	// if (only specific fields / nur bestimmte Felder)																	
			qc["fromNextLoad"] = 0;	// next table to load / nchste zu ladende Tabelle	
			qc["func"] = qfunc;			
			
//  for debug:
//	alert(qc["select"]);
//	alert("s:" + qc["select"]);
//	alert("d:" +qc["distinct"]);			
//	alert("a:" + qc["as"]);
//	alert("f:" + qc["from"]);	
//	alert("w: "+ qc["where"]);							
//  alert("o: " + qc["order"]);
			
			tableLoader(qc);
		}	// query()
		
	}	// public interface
})();	// publicSQL